/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWBackGroundPanel;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWAboutHelper
extends JDialog
implements ActionListener {
    private Frame m_parentFrame = null;
    private String m_productName = null;
    private Font m_copyrightFont = null;
    private JButton m_OKButton = null;

    public VWAboutHelper(Frame parentFrame, String productName, ImageIcon icon, VWSessionInfo sessionInfo) {
        super(parentFrame, true);
        try {
            this.m_parentFrame = parentFrame;
            this.m_productName = productName;
            this.setUndecorated(true);
            this.init(sessionInfo);
            this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void display() {
        this.setVisible(true);
    }

    public void setFont(Font newFont) {
        if (newFont != null) {
            this.m_copyrightFont = newFont;
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_OKButton) {
            this.setVisible(false);
        }
    }

    private void init(VWSessionInfo sessionInfo) {
        VWBackGroundPanel bkgPanel = new VWBackGroundPanel((LayoutManager)new BorderLayout(), "aboutBoxBackground.gif");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)bkgPanel, "Center");
        Dimension dim = bkgPanel.getPreferredSize();
        if (dim == null) {
            dim = new Dimension(650, 460);
        }
        this.setSize(dim);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        JPanel mainPanel = this.getMainPanel(sessionInfo);
        if (mainPanel != null) {
            mainPanel.setOpaque(false);
            bkgPanel.add((Component)mainPanel, "Center");
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setOpaque(false);
        this.m_OKButton = new JButton(VWResource.s_ok);
        this.m_OKButton.setSelected(true);
        this.m_OKButton.addActionListener(this);
        buttonPanel.add(this.m_OKButton);
        VWAccessibilityHelper.setAccessibility(this.m_OKButton, this, VWResource.s_ok, VWResource.s_ok);
        this.m_OKButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.getRootPane().setDefaultButton(this.m_OKButton);
        bkgPanel.add((Component)buttonPanel, "Last");
    }

    private JPanel getMainPanel(VWSessionInfo sessionInfo) {
        JLabel fullProductNameLabel = null;
        Font smallLabelFont = null;
        JLabel localizedDateTimeLabel = null;
        JLabel isolatedRegionInfoLabel = null;
        try {
            fullProductNameLabel = new JLabel(VWIDMBaseFactory.instance().getVWString(10).toString(this.m_productName, "5.0.0.4"));
            VWAccessibilityHelper.setAccessibility(fullProductNameLabel, this, fullProductNameLabel.getText(), fullProductNameLabel.getText());
            fullProductNameLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            smallLabelFont = fullProductNameLabel.getFont();
            smallLabelFont = new Font(smallLabelFont.getName(), 0, smallLabelFont.getSize() - 1);
            localizedDateTimeLabel = new JLabel(this.getLocalizedBuildTime());
            localizedDateTimeLabel.setFont(smallLabelFont);
            VWAccessibilityHelper.setAccessibility(localizedDateTimeLabel, this, localizedDateTimeLabel.getText(), localizedDateTimeLabel.getText());
            localizedDateTimeLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            if (sessionInfo != null && sessionInfo.getSession() != null) {
                String connectionPoint = sessionInfo.getSession().getConnectionPointName();
                isolatedRegionInfoLabel = connectionPoint == null || connectionPoint.length() == 0 ? new JLabel(VWResource.s_isolatedRegion + " " + sessionInfo.getSession().getIsolatedRegion()) : new JLabel(VWResource.s_isolatedRegion + " " + sessionInfo.getSession().getIsolatedRegion() + "  (" + connectionPoint + ")");
                isolatedRegionInfoLabel.setFont(smallLabelFont);
                VWAccessibilityHelper.setAccessibility(isolatedRegionInfoLabel, this, isolatedRegionInfoLabel.getText(), isolatedRegionInfoLabel.getText());
                isolatedRegionInfoLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        mainPanel.setOpaque(false);
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.anchor = 21;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.fill = 2;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(1, 20, 1, 1);
        mainPanel.add(Box.createVerticalStrut(200), gbCons);
        ++gbCons.gridy;
        gbCons.insets = new Insets(1, 20, 1, 1);
        mainPanel.add((Component)fullProductNameLabel, gbCons);
        ++gbCons.gridy;
        mainPanel.add((Component)localizedDateTimeLabel, gbCons);
        ++gbCons.gridy;
        if (isolatedRegionInfoLabel != null) {
            mainPanel.add((Component)isolatedRegionInfoLabel, gbCons);
        }
        ++gbCons.gridy;
        gbCons.weighty = 0.3;
        gbCons.fill = 1;
        gbCons.insets = new Insets(10, 20, 1, 1);
        JPanel thirdPartyCopyrightPanel = this.getThirdPartyCopyrightPanel();
        if (thirdPartyCopyrightPanel != null) {
            thirdPartyCopyrightPanel.setOpaque(false);
            mainPanel.add((Component)thirdPartyCopyrightPanel, gbCons);
        }
        return mainPanel;
    }

    private String getLocalizedBuildTime() {
        try {
            String buildLine = "pui460.004.038";
            String buildDateMask = "MM/dd/yyyy HH:mm:ss";
            SimpleDateFormat dateFormatter = new SimpleDateFormat(buildDateMask);
            Date buildDateTime = dateFormatter.parse("08/06/2012 10:54:27");
            return buildLine.toUpperCase() + " - " + dateFormatter.format(buildDateTime);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getThirdPartyCopyrightPanel() {
        String thirdPartyCopyright = null;
        try {
            thirdPartyCopyright = VWIDMBaseFactory.instance().getVWString(15).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (thirdPartyCopyright == null || thirdPartyCopyright.length() == 0) {
            return null;
        }
        JPanel noticePanel = new JPanel(new BorderLayout());
        JTextArea noticeTextArea = new JTextArea(thirdPartyCopyright);
        noticeTextArea.setEditable(false);
        noticeTextArea.setLineWrap(true);
        noticeTextArea.setWrapStyleWord(true);
        VWAccessibilityHelper.setAccessibility(noticeTextArea, this, thirdPartyCopyright, thirdPartyCopyright);
        noticeTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
        try {
            if (this.m_copyrightFont == null) {
                String fontName = VWResource.s_timesNewRomanFont;
                int fontSize = Integer.valueOf("10");
                this.m_copyrightFont = this.createFont(fontName, fontSize);
            }
            noticeTextArea.setFont(this.m_copyrightFont);
        }
        catch (VWException ex) {
            // empty catch block
        }
        JScrollPane scrollPane = new JScrollPane(noticeTextArea);
        scrollPane.setBorder(null);
        noticePanel.add((Component)scrollPane, "Center");
        return noticePanel;
    }

    private Font createFont(String name, int size) throws VWException {
        try {
            Font newFont;
            if (name.length() > 0 && size > 0 && (newFont = new Font(name, 0, size)) != null) {
                return newFont;
            }
        }
        catch (Exception ex) {
            throw new VWException("VWAboutHelper.invalidFont", "An error occurred creating the font: {0}, {1}", name, new Integer(size).toString());
        }
        return null;
    }
}

